#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>


using namespace std;

const int MAX_N = 100005;
const int INF = 1000000000;

struct Fenwick {
    int n, m[MAX_N];

    void initialize(int _n) {
        n = _n;

        for (int i = 0; i <= n; i++) {
            m[i] = INF;
        }
    }

    void update(int x, int val) {
        for (int i = x + 1; i <= n; i += (i & -i)) {
            m[i] = min(m[i], val);
        }
    }

    int query(int x) {
        int ans = INF;

        for (int i = x + 1; i > 0; i -= (i & -i)) {
            ans = min(m[i], ans);
        }

        return ans;
    }
};

int n;
pair< int, pair< int, int > > r[MAX_N];
Fenwick f;

int main()
{
	//ios_base::sync_with_stdio(false);
	//freopen(".in", "r", stdin);
	//freopen(".out", "w", stdout);

    int tests;

    scanf("%d", &tests);

    for (int test_id = 0; test_id < tests; test_id++) {
        scanf("%d", &n);

        for (int i = 0; i < n; i++) {
            scanf("%d %d %d", &r[i].first, &r[i].second.first, &r[i].second.second);
        }

        sort(r, r + n);

        f.initialize(n + 1);
        
        int cnt = 0;
        for (int i = 0; i < n; i++) {
            if (f.query(r[i].second.first) < r[i].second.second) {
                cnt++;
            }

            f.update(r[i].second.first, r[i].second.second);
        }

        printf("%d\n", n - cnt);
    }

    return 0;
}
